/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2008 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.kintai.action;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

import jp.mosp.common.CommonConst;
import jp.mosp.common.action.MosPWorkflowAction;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;

import jp.mosp.human.dto.MKihonDto;

import jp.mosp.kintai.dto.MSyukkinboDto;
import jp.mosp.kintai.vo.ApprovalListVo;

import jp.mosp.workflow.dto.AmUnitDto;

public class ApprovalListAction extends MosPWorkflowAction {

	// R}h
	private static final String CMD_APPROVAL_LIST_SELECT		= "K2111";
	public  static final String CMD_APPROVAL_LIST_SEARCH		= "K2112";
	private static final String CMD_LUMP_SUM_1ST_APPROVAL		= "K2113";	
	private static final String CMD_LUMP_SUM_2ND_APPROVAL		= "K2114";	

	// LFtO
	private boolean is1stApproval = false;
	private boolean is2ndApproval = false;

	// FctO
	private boolean is1stRemain = false;
	private boolean is2ndRemain = false;

	/**
	 * RXgN^
	 */
	public ApprovalListAction() {
		super();
	}

	/**
	 * ANV
	 */
	public void action() throws Exception {
		// RlNV擾
		getConnection();
		// MANAGERmF
		confirmManagerAuth();
		// VO̎擾
		ApprovalListVo vo;
		vo = (ApprovalListVo)getStoredVo(CommonConst.VO_APPROVAL_LIST);
		if (vo == null) {
			vo = new ApprovalListVo();
		}
		vo.initVo(cfg, msg, cmd, aspUser, user);
		vo.clearMessage();
		vo.clearErrField();
		storeVo(CommonConst.VO_APPROVAL_LIST, vo);
		// VOyуtH[hURL̐ݒ
		setVo(vo);
		setUrl(vo.getRetUrl());
		// DBRlNV擾
		getConnection();
		// [U[擾
		getInfo(user.getUserId());
		// \
		//Date current = getCalcAttendance();
		Date current = getCalcMonth();
		// ΑӊǗR}h
		vo.setCmdMenuButton(vo.CMD_MENU_MAMAGE);
		vo.setCmdListButton(EmployeeApprovalListAction.CMD_APPROVAL_LIST_RE_SEARCH);
		vo.setNamListButton(CommonConst.TTL_EMPLOYEE_APPROVAL);
		// v_E擾
		vo.aryPltYear  = util.getYearArray(MospUtility.getYear (current));
		vo.aryPltMonth = util.getMonthArray();
		// R}h̏
		if (cmd.equals(CMD_APPROVAL_LIST_SELECT)) {
			// I
			// ΏێЈݒ
			vo.setSelectKCode(key1);
			// Ώ۔Nݒ
			String[] aryDate = util.divideByHyphen(key2, 1);
			vo.setPltYear(aryDate[0]);
			vo.setPltMonth(aryDate[1]);
			// \
			show(vo);
		} else if (cmd.equals(CMD_APPROVAL_LIST_SEARCH)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// \
			show(vo);
		} else if (cmd.equals(CMD_LUMP_SUM_1ST_APPROVAL)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// ꗗꎟF
			runApprovalProcess(vo);
			// \
			show(vo);
		} else if (cmd.equals(CMD_LUMP_SUM_2ND_APPROVAL)) {
			// Ώ۔Nݒ
			vo.setParams(request);
			// ꗗ񎟏F
			runApprovalProcess(vo);
			// \
			show(vo);
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}  
	}

	/**
	 * \
	 * @param vo			ΏVO
	 * @throws Exception
	 */
	private void show(ApprovalListVo vo) throws Exception {
		// F̃Zbg
		setApprovalAuth(vo);
		// 
		searchApprovalList(vo);
		// [hݒ
		setMode(vo);
	}
	
	/**
	 * Fݒ
	 * @param vo
	 * @throws Exception
	 */
	private void setApprovalAuth(ApprovalListVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Ώ۔N擾
		Date targetDate = util.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// F[gݒ
		String[] aryRouteInfo = getTargetRouteInfo(vo.getSelectKCode(), targetDate);
		// ꎟF
		String layer1 = aryRouteInfo[0];
		// 񎟏F
		String lastLayer = aryRouteInfo[1];
		// DAȌ
		prepareAmUnitDao();
		// ̎擾
		AmUnitDto layer1Dto = unitDao.findForCurrentUnit(
				layer1,
				mKihon.getKCode(),
				util.convDateFormattedByHyphen(targetDate)
		);
		AmUnitDto lastLayerDto = unitDao.findForCurrentUnit(
				lastLayer,
				mKihon.getKCode(),
				util.convDateFormattedByHyphen(targetDate)
		);
		if (chkExistDto(layer1Dto)) {
			is1stApproval = true;
		}
		if (chkExistDto(lastLayerDto)) {
			is2ndApproval = true;
		}
	}

	/**
	 * Αӈꗗ
	 * @param vo VoCX^X
	 * @throws Exception
	 */
	private void searchApprovalList(
			ApprovalListVo vo
	) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// ΏۊԐݒ
		Date targetMonth = util.getYearMonth(vo.getPltYear(), vo.getPltMonth());
		// ΑӃf[^擾
		/*						
		 *  	2009/01/20	m.yoshida	ߓΉ
		 */
		getAttendanceListForView(vo.getSelectKCode(), targetMonth);
		// Wvf[^Ԑݒ
		setHours();
		// Wvf[^z쐬
		makeApprovalArray();
		// Wv
		totalAttendanceDaily();
		// F̃Zbg
		setApprovalInfo(vo);
		// l{̎擾
		MKihonDto mKihonDto = getBasisInfo(vo.getSelectKCode());
		// I̐ݒ
		vo.setSelectKName(mKihonDto.getSimei());
		vo.setSelectSectionName(util.getCodeName(mKihonDto.getSCode(), getSectionArrayAll()));
		// Wvf[^ƃx𕪗
		String[] aryLabel 	= new String[aryAttendanceCompile.length];
		String[] aryCompile = new String[aryAttendanceCompile.length];
		for (int i = 0; i < aryAttendanceCompile.length; i++) {
			aryLabel[i] = aryAttendanceCompile[i][0];
			aryCompile[i] = aryAttendanceCompile[i][1];
		}
		// VOݒ
		vo.setFields(aryAttendance, aryCompile, aryLabel);
	}

	/**
	 * Wvf[^z쐬
	 * @throws Exception
	 */
	private void makeApprovalArray() throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// f[^擾
		Calendar cal = Calendar.getInstance();
		cal.setTime(MospUtility.getDate(startDate));
		int count = 0;
		while (MospUtility.getDate(endDate).compareTo(cal.getTime()) >= 0) {
			cal.add(Calendar.DAY_OF_MONTH, 1);
			count++;
		}
		// z񏉊
		aryAttendance = new String[count][40];
		for (int i = 0; i < aryAttendance.length; i++) {
			for (int j = 0; j < aryAttendance[i].length; j++) {
				aryAttendance[i][j] = "";
			}
		}
		// tݒ
		cal.setTime(MospUtility.getDate(startDate));
		for (int i = 0; i < aryAttendance.length; i++) {
			// tipj
			aryAttendance[i][0] = MospUtility.getDateString(cal.getTime(), CommonConst.FORMAT_DATE);
			// t
			aryAttendance[i][1] = String.valueOf(MospUtility.getMonth(cal.getTime()))
			+ CommonConst.SEPARATOR_DATE
			+ String.valueOf(cal.get(Calendar.DAY_OF_MONTH));
			// j
			aryAttendance[i][2] = getDayOfWeek(cal.get(Calendar.DAY_OF_WEEK));
			// lijՓAxj
			StringBuffer remark = new StringBuffer();
			String holidayName = getPublicHolidayName(cal.getTime());
			if (holidayName.length() != 0) {
				remark.append(holidayName);
				remark.append(CommonConst.NAM_COMMON_HALF_KANA_SPACE);
			}
			aryAttendance[i][16] = remark.toString();
			cal.add(Calendar.DAY_OF_MONTH, 1);
		}
		// f[^̐ݒ
		Iterator<MSyukkinboDto> it = attendanceList.iterator();
		while (it.hasNext()) {
			cal.setTime(MospUtility.getDate(startDate));
			MSyukkinboDto dto = it.next();
			Date attendanceDate = MospUtility.getDate(dto.getHizuke());
			for (int i = 0; i < aryAttendance.length; i++) {
				if (attendanceDate.compareTo(cal.getTime()) == 0) {
					// Ζ`
					String kinmu = "";
					// o΂̏ꍇ
					if (isAvailableWorkType(dto)) {
						kinmu = workTypeMap.get(dto.getKinmu()).getShiftName();
						// oΎ
						aryAttendance[i][4 ] = dto.getSyJikoku();
						// ދΎ
						aryAttendance[i][5 ] = dto.getTaJikoku();
						// Ζ
						aryAttendance[i][6 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKinmuJi()));
						// xe
						aryAttendance[i][7 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKyukeiJi()));
						// x
						aryAttendance[i][8 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getTiJikan()));
						// ގ
						aryAttendance[i][9 ] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSoJikan()));
						// cƎ
						aryAttendance[i][10] = getHourString(util.convIntegerTimeToDoubleTime(dto.getZaJikan()));
						// xo
						aryAttendance[i][11] = getHourString(util.convIntegerTimeToDoubleTime(dto.getKsJikan()));
						// [鎞
						aryAttendance[i][12] = getHourString(util.convIntegerTimeToDoubleTime(dto.getSnJikan()));
					} else if (isWeekHoliday(dto)) {
						kinmu = CommonConst.ATTENDANCE_TYPE_WEEK_HOLIDAY;
					} else {
						for (int k = 0; k < aryHolidayReason.length; k++) {
							if (aryHolidayReason[k][0].equals(dto.getKKRiyuu())) {
								kinmu = aryHolidayReason[k][1];
							}
						}
					}
					aryAttendance[i][3 ] = kinmu;
					// ꎟFA񎟏F
					String result = dto.getSnRiyuu();
					aryAttendance[i][13] = util.getCodeName(result, aryApprovalReason);
					if (isRequest(result)) {
						is1stRemain = true;
						// ꎟFۗL̏ꍇ
						if (is1stApproval) {
							aryAttendance[i][14] = result;							
						}
					} else if (is1stApproved(result)) {
						// 񎟏FۗL̏ꍇ
						is2ndRemain = true;
						if (is2ndApproval) {
							aryAttendance[i][14] = result;							
						}
					}
					// F
					aryAttendance[i][15] = getKName(dto.getNinsyo());
					// x
					if (isStartHalfHoliday(dto) || isQuitHalfHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_VACATION_LEAVE_HALF + CommonConst.NAM_COMMON_HALF_KANA_SPACE;
					}
					if (isWorkOnHoliday(dto)) {
						aryAttendance[i][16] += CommonConst.NAM_WORK_ON_HOLIDAY + CommonConst.NAM_COMMON_HALF_KANA_SPACE;		
					}
					break;
				}
				cal.add(Calendar.DAY_OF_MONTH, 1);
			}
		}
	}

	/**
	 * ΑӏF
	 * @param vo
	 * @throws Exception
	 */
	private void setApprovalInfo(ApprovalListVo vo) throws Exception {
		// DBRlNV擾
		if (conn == null) {
			getConnection();
		}
		// Ώ۔N擾
		Date targetDate = util.getFirstDateOfMonth(vo.getPltYear(), vo.getPltMonth());
		// F[gݒ
		String[] aryRouteInfo = getTargetRouteInfo(vo.getSelectKCode(), targetDate);
		// ꎟF
		String layer1 = aryRouteInfo[0];
		// 񎟏F
		String lastLayer = aryRouteInfo[1];
		if (layer1.equals("") || lastLayer.equals("")) {
			// ΑӏNA
			for (int i = 0; i < aryAttendance.length; i++) {
				aryAttendance[i][3 ] = "";
				aryAttendance[i][4 ] = "";
				aryAttendance[i][5 ] = "";
				aryAttendance[i][6 ] = "";
				aryAttendance[i][7 ] = "";
				aryAttendance[i][8 ] = "";
				aryAttendance[i][9 ] = "";
				aryAttendance[i][10] = "";
				aryAttendance[i][11] = "";
				aryAttendance[i][12] = "";
				aryAttendance[i][13] = "";
				aryAttendance[i][14] = "";
			}
			for (int i = 0; i < aryAttendanceCompile.length; i++) {
				aryAttendanceCompile[i][1] = "0";
			}
		}
		// ̏FۗLĂꍇ̐\c̏
		for (int i = 0; i < aryAttendance.length; i++) {
			if (is1stRemain 
					&& is1stApproval
					&& is2ndApproval 
					&& is1stApproved(aryAttendance[i][14])
			) {
				aryAttendance[i][14] = "";
			}
		}
	}

	/**
	 * ꗗF
	 * @param vo			ΏVO
	 * @param cmd			IFKw
	 * @throws Exception
	 */
	private void runApprovalProcess(ApprovalListVo vo) throws Exception {
		// FR
		String reason = "";
		// FRg
		String comment = "";
		// ꎟF
		if (cmd.equals(CMD_LUMP_SUM_1ST_APPROVAL)) {
			reason = CommonConst.NUM_ATTENDANCE_1ST_APPROVED;
			comment = MospUtility.getMessage(
					msg, CommonConst.MSG_NUMBER_OF_APPROVED, CommonConst.getKanjiNumberArray()[1]);
		}
		// 񎟏F
		if (cmd.equals(CMD_LUMP_SUM_2ND_APPROVAL)) {
			reason = CommonConst.NUM_ATTENDANCE_2ND_APPROVED;
			comment = MospUtility.getMessage(
					msg, CommonConst.MSG_NUMBER_OF_APPROVED, CommonConst.getKanjiNumberArray()[2]);
		}
		// Ώ۔N
		String[] aryTargetDate = vo.getAryApprovalDate();
		for (int i = 0; i < aryTargetDate.length; i++) {
			// F
			runApprovalProcess(vo.getSelectKCode(), aryTargetDate[i], reason, comment, mKihon.getKCode());			
		}
		// R~bg
		commit();	
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
	}

	/**
	 * F[hݒ
	 * @param vo
	 */
	private void setMode(ApprovalListVo vo) {
		// o΃tOiLxxɂ܂߂j
		boolean isAttendance = false;
		int count = 0;
		for (int i = 0; i < vo.getEscAryAttendance().length; i++) {
			if (!vo.getEscAryAttendance()[i][3].equals("")) {
				count++;
			}
		}
		if (count > 0) {
			isAttendance = true;
		}
		// ꌏłꎟFcĂꍇAꎟFD悳B
		if (is1stRemain) {
			if (is1stApproval) {
				vo.setMode(ApprovalListVo.MODE_1ST_APPROVAL);
			} else if (is2ndApproval) {
				vo.setMode(ApprovalListVo.MODE_2ND_APPROVAL);
			}
		} else if (is2ndApproval && isAttendance && is2ndRemain) {
			vo.setMode(ApprovalListVo.MODE_2ND_APPROVAL);
		} else {
			vo.setMode(ApprovalListVo.MODE_NOT_AUTH);
		}
	}

}
